/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.canvas.process.diagram;

import filenet.vw.api.VWRouteDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.canvas.process.VWDesignerBasePropertyPanel;
import filenet.vw.toolkit.design.canvas.process.VWPropertyMenuItem;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class VWDiagramRoutePropertyPanel
extends VWDesignerBasePropertyPanel
implements DocumentListener,
IVWPropertyChangeSource {
    protected VWRouteDefinition m_selectedRouteDef = null;
    protected Vector m_changedItems = null;
    protected JTextField m_nameTextField;
    protected JTextArea m_descriptionTextArea;

    public VWDiagramRoutePropertyPanel(VWAuthPropertyData authPropertyData) {
        super(authPropertyData);
    }

    public Object getDataObject() {
        return this.m_selectedRouteDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setDataObject(Object dataObject) {
        try {
            try {
                block11: {
                    block10: {
                        if (dataObject == null || !(dataObject instanceof VWRouteDefinition)) break block10;
                        if (dataObject != this.m_selectedRouteDef) break block11;
                    }
                    Object var4_2 = null;
                    this.m_nameTextField.getDocument().addDocumentListener(this);
                    this.m_descriptionTextArea.getDocument().addDocumentListener(this);
                    return;
                }
                this.m_selectedRouteDef = (VWRouteDefinition)dataObject;
                this.m_nameTextField.getDocument().removeDocumentListener(this);
                this.m_descriptionTextArea.getDocument().removeDocumentListener(this);
                this.m_nameTextField.setText("");
                this.m_descriptionTextArea.setText("");
                if (this.m_selectedRouteDef != null) {
                    this.m_nameTextField.setText(this.m_selectedRouteDef.getName());
                    this.m_descriptionTextArea.setText(this.m_selectedRouteDef.getDescription());
                }
                this.setEnabled(this.m_authPropertyData.isCurrentMapEditable());
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var4_4 = null;
                this.m_nameTextField.getDocument().addDocumentListener(this);
                this.m_descriptionTextArea.getDocument().addDocumentListener(this);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.m_nameTextField.getDocument().addDocumentListener(this);
            this.m_descriptionTextArea.getDocument().addDocumentListener(this);
            throw throwable;
        }
        Object var4_3 = null;
        this.m_nameTextField.getDocument().addDocumentListener(this);
        this.m_descriptionTextArea.getDocument().addDocumentListener(this);
    }

    public String getDisplayName() {
        String name = this.getToolTip();
        if (name != null) {
            name = this.getFormattedTabName(name);
        }
        return name;
    }

    public String getToolTip() {
        if (this.m_selectedRouteDef != null) {
            return VWPropertyMenuItem.getDisplayName(this.m_selectedRouteDef);
        }
        return null;
    }

    public Icon getIcon() {
        return VWImageLoader.createImageIcon("route_16.gif");
    }

    public void displayHelpPage() {
        VWHelp.displayPage(VWHelp.Help_Process_Designer + "bpfdh143.htm");
    }

    public void releaseReferences() {
        if (this.m_nameTextField != null) {
            this.m_nameTextField.getDocument().removeDocumentListener(this);
            this.m_nameTextField.removeAll();
            this.m_nameTextField = null;
        }
        if (this.m_descriptionTextArea != null) {
            this.m_descriptionTextArea.getDocument().removeDocumentListener(this);
            this.m_descriptionTextArea.removeAll();
            this.m_descriptionTextArea = null;
        }
        super.releaseReferences();
    }

    public void changedUpdate(DocumentEvent event) {
    }

    public void insertUpdate(DocumentEvent event) {
        if (this.m_selectedRouteDef == null) {
            return;
        }
        if (event.getDocument() == this.m_nameTextField.getDocument()) {
            this.updateName();
        } else if (event.getDocument() == this.m_descriptionTextArea.getDocument()) {
            this.m_selectedRouteDef.setDescription(this.m_descriptionTextArea.getText());
            this.m_authPropertyData.setDirty();
        }
    }

    public void removeUpdate(DocumentEvent event) {
        if (this.m_selectedRouteDef == null) {
            return;
        }
        if (event.getDocument() == this.m_nameTextField.getDocument()) {
            this.updateName();
        } else if (event.getDocument() == this.m_descriptionTextArea.getDocument()) {
            this.m_selectedRouteDef.setDescription(this.m_descriptionTextArea.getText());
            this.m_authPropertyData.setDirty();
        }
    }

    public void notifyPropertyChange() {
        this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 501);
    }

    public Vector getItemsChanged() {
        return this.m_changedItems;
    }

    protected void createControls() {
        try {
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(5, 5, 5, 5);
            this.add((Component)this.getNamePanel(), gbCons);
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weighty = 1.0;
            gbCons.insets = new Insets(5, 5, 0, 5);
            this.add((Component)this.getDescriptionPanel(), gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel getNamePanel() {
        try {
            VWToolbarBorder routeNameBorder = new VWToolbarBorder(VWResource.s_route);
            JPanel childPanel = routeNameBorder.getClientPanel();
            childPanel.setLayout(new BorderLayout());
            this.m_nameTextField = new JTextField("", 15);
            this.m_nameTextField.setName("m_nameTextField_VWDiagramRoutePropertyPanel");
            this.m_nameTextField.setEditable(true);
            this.m_nameTextField.getDocument().addDocumentListener(this);
            this.m_controls.addElement(this.m_nameTextField);
            childPanel.add((Component)this.m_nameTextField, "First");
            return routeNameBorder;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getDescriptionPanel() {
        try {
            VWToolbarBorder descriptionBorder = new VWToolbarBorder(VWResource.s_descriptionStr);
            JPanel childPanel = descriptionBorder.getClientPanel();
            childPanel.setLayout(new BorderLayout());
            this.m_descriptionTextArea = new JTextArea();
            this.m_descriptionTextArea.setName("m_descriptionTextArea_VWDiagramProcessPropertyPanel");
            this.m_descriptionTextArea.setLineWrap(true);
            this.m_descriptionTextArea.setWrapStyleWord(true);
            this.m_descriptionTextArea.setRows(3);
            this.m_descriptionTextArea.getDocument().addDocumentListener(this);
            this.m_controls.addElement(this.m_descriptionTextArea);
            childPanel.add((Component)new JScrollPane(this.m_descriptionTextArea), "Center");
            return descriptionBorder;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void updateName() {
        try {
            if (this.m_selectedRouteDef != null && this.m_nameTextField != null) {
                String name = this.m_nameTextField.getText();
                String blankName = VWPropertyMenuItem.getBlankName(this.m_selectedRouteDef);
                if ((name.length() == 0 || name.equals(blankName)) && this.m_selectedRouteDef.getName() == null) {
                    return;
                }
                this.m_selectedRouteDef.setName(name);
                this.m_authPropertyData.setDirty();
                this.m_changedItems = new Vector();
                this.m_changedItems.addElement(this.m_selectedRouteDef);
                this.notifyPropertyChange();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

